<?php
/*
WP-Amazon Plugin for Wordpress 1.5+
Version ttb1.1 2007.5.19

Copyright (C) 2005 Rich Manalang
Modded for WP2.2 by ttancm www.ttancm.com
Additional fix by Neetij neetij.com


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
USA

/* Debug flag */
$debug = false;

$areMagicQuotesOn = get_magic_quotes_gpc();

$title = 'Insert item from Amazon.com';

require_once('../../wp-config.php');
include_once(ABSPATH . '/wp-includes/version.php');
require_once (ABSPATH . '/wp-includes/l10n.php');
require_once (ABSPATH . '/wp-admin/admin-functions.php');

$Country = get_option('wpamazon_country');
$AssociateTag = get_option('wpamazon_associate_id');
$SubscriptionID = get_option('wpamazon_subscription_id');

// Set defaults if properties aren't set
if ( !$Country )
{
	$Country = 'US';
	update_option('wpamazon_country', $Country);
}

if ( !$AssociateTag )
{
	$AssociateTag = 'manalangcom-20';
	update_option('wpamazon_associate_id', $AssociateTag);
}

if ( !$SubscriptionID)
{
	$SubscriptionID = '0EMV44A9A5YT1RVDGZ82';
	update_option('wpamazon_subscription_id', $SubscriptionID);
}

parse_str($_SERVER["QUERY_STRING"]);

$XML_LIST_ELEMENTS = array ("SearchIndex", "ASIN", "Item");

function makeXMLTree_wpa($file) {

    /* Added check for curl... use curl when possible
     * because of security concerns with allow_url_fopen */

    if (function_exists(curl_init)) {
    	// John White read file
    	$ch = curl_init($file);
    	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    	$data = curl_exec($ch);
    	curl_close($ch);   // John White end of curl read file fopen replace
    } else {
		// curl not available use fopen instead
    	$open_file = fopen($file, "r");
    	$data = "";
    	while ($r = fread($open_file, 8192)) {
    	        $data .= $r;
    	}
	}

	// create parser
	$parser = xml_parser_create();
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
	xml_parse_into_struct($parser, $data, $values, $tags);
	xml_parser_free($parser);

	// we store our path here
	$hash_stack = array ();

	// this is our target
	$ret = array ();
	foreach ($values as $key => $val) {

		switch ($val['type']) {
			case 'open' :
				array_push($hash_stack, $val['tag']);
				if (isset ($val['attributes']))
					$ret = composeArray($ret, $hash_stack, $val['attributes']);
				else
					$ret = composeArray($ret, $hash_stack);
				break;

			case 'close' :
				array_pop($hash_stack);
				break;

			case 'complete' :
				array_push($hash_stack, $val['tag']);
				$ret = composeArray($ret, $hash_stack, $val['value']);
				array_pop($hash_stack);

				// handle attributes
				if (isset ($val['attributes'])) {
					while (list ($a_k, $a_v) = each($val['attributes'])) {
						$hash_stack[] = $val['tag']."_attribute_".$a_k;
						$ret = composeArray($ret, $hash_stack, $a_v);
						array_pop($hash_stack);
					}
				}

				break;
		}
	}
    return $ret;
}

function & composeArray($array, $elements, $value = array ()) {
	global $XML_LIST_ELEMENTS;

	// get current element
	$element = array_shift($elements);

	// does the current element refer to a list
	if (in_array($element, $XML_LIST_ELEMENTS)) {
		// more elements?
		if (sizeof($elements) > 0) {
			$array[$element][sizeof($array[$element]) - 1] = & composeArray($array[$element][sizeof($array[$element]) - 1], $elements, $value);
		} else // if (is_array($value))
			{
			$array[$element][sizeof($array[$element])] = $value;
		}
	} else {
		// more elements?
		if (sizeof($elements) > 0) {
			$array[$element] = & composeArray($array[$element], $elements, $value);
		} else {
			$array[$element] = $value;
		}
	}

	return $array;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>WordPress &rsaquo;&rsaquo; <?php print $title; ?></title>
<link rel="stylesheet" href="../../wp-admin/wp-admin.css" type="text/css" />
<link rel="shortcut icon" href="../../wp-images/wp-favicon.png" />
<meta http-equiv="Content-Type" content="text/html; charset=<?php print get_settings('blog_charset');?>" />
<script type="text/javascript">
<!--
window.focus();

// modified version of a script from Alex King (http://www.alexking.org)
// the code did not support the AtCursor across multiple windows
function insertAtCursor(myField, myValue) {
	//IE support
	if (document.selection) {
		// only insert text for IE (not at cursor)
		myField.value += myValue;
	}
	//MOZILLA/NETSCAPE support
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		myField.value = myField.value.substring(0, startPos)
			+ myValue
			+ myField.value.substring(endPos, myField.value.length);
	} else {
		myField.value += myValue;
	}
}

function generateHTMLCode(format,prodname,url,imgurl) {
	if (format=='link') {
		html = '<a href="'+url+'" title="View product details at Amazon">'+prodname+'</a>';
	} else {
		html = '<a href="'+url+'" title="View product details at Amazon"><img src="'+imgurl+'" alt="'+prodname+'" /></a>';
	}
	htmlCode = document.getElementById("htmlcode")
	htmlCode.value = html;
}
//-->
</script>
<style type="text/css">
<!--
body {
	margin:10px;
}
#search {
	padding:5px;
}
#query {
	width:200px;
}
#results {
	margin:5px 0px;
	border:1px solid #ccc;
	padding:0 5px 5px 5px;
	background: #eee;
}
#results h2 {
	font-size:1.25em;
	font-weight:bold;
	margin:5px 0 10px 0;
	padding:0;
	border-bottom:1px solid;
}
#results h2 a {
	text-decoration:none;
	border-bottom:none;
}
#results .mode {
	margin: .5em;
	padding: .5em;
}
#results .mode h3 {
	font-size: 1em;
	color:#333;
	margin: 0;
	padding: 0;
	border-bottom:1px #333 solid;
	text-transform:capitalize;
}
#results .item {
	margin: 0;
	padding: 5px;
	border-bottom:1px solid #ccc;
	clear:both;
}
#results .item:after {
    content: ".";
    display: block;
    height: 0;
    clear: both;
    visibility: hidden;
}
#results h4 {
	display: inline;
	font-size: .9em;
	font-weight: normal;
	margin: 0;
	padding: 0;
}
#results form {
	padding: 0;
	margin:0;
	display:block;
	text-align:right !important;
}
#results img {
	float:left;
	margin:5px;
	border:1px solid #000;
}
#results input {
	margin: 10px 0 0 0;
}
#results textarea {
	width:95%;
	height:150px;
	margin:5px;
}
#options {
	padding: 5px;
}
.button, .button:focus {
	background: url(../../wp-images/fade-butt.png) !important;
	border: 3px double #999 !important;
	border-left-color: #ccc !important;
	border-top-color: #ccc!important;
	color: #333;
	padding:.05em;
}

.button:active {
	border: 3px double #ccc;
	border-left-color: #999;
	border-top-color: #999;
}
.radio {
	border:0;
	background:transparent;
}
-->
</style>
</head>
<body>

<?php
$ThisPage = $_SERVER['PHP_SELF'];

$CountryArray = array (
	"US" =>
		array ("BaseURL" => "http://webservices.amazon.com/onca/xml?Service=AWSECommerceService",
			"Descr" => "United States",
			"URL" => "Amazon.com"),
	"UK" =>
		array ("BaseURL" => "http://webservices.amazon.co.uk/onca/xml?Service=AWSECommerceService",
			"Descr" => "United Kingdom",
			"URL" => "Amazon.co.uk"),
	"DE" =>
		array ("BaseURL" => "http://webservices.amazon.de/onca/xml?Service=AWSECommerceService",
			"Descr" => "Germany",
			"URL" => "Amazon.de"),
	"JP" =>
		array ("BaseURL" => "http://webservices.amazon.co.jp/onca/xml?Service=AWSECommerceService",
			"Descr" => "Japan",
			"URL" => "Amazon.co.jp"),
	"CA" =>
		array ("BaseURL" => "http://webservices.amazon.ca/onca/xml?Service=AWSECommerceService",
			"Descr" => "Canada",
			"URL" => "Amazon.ca"),
	"FR" =>
		array ("BaseURL" => "http://webservices.amazon.fr/onca/xml?Service=AWSECommerceService",
			"Descr" => "France",
			"URL" => "Amazon.fr")
	);

$SearchIndexArray = array (
	"Blended" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "All Products"),
	"Apparel" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Apparel"),
	"Baby" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Baby"),
	"Beauty" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Beauty"),
	"Books" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "Books"),
	"Classical" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "Classical Music"),
	"DigitalMusic" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Digital Music"),
	"DVD" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "DVD"),
	"Electronics" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => false, "FR" => false,
			"Descr" => "Electronics"),
	"ForeignBooks" =>
		array ("US" => false, "UK" =>false, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "Foreign Books"),
	"GourmetFood" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Gourmet Food"),
	"HealthPersonalCare" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Health &amp; Personal Care"),
	"HomeGarden" =>
		array ("US" => false, "UK" =>true, "DE" => true, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Home &amp; Garden"),
	"Jewelry" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Jewelry"),
	"Kitchen" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => false, "FR" => false,
			"Descr" => "Kitchen"),
	"Magazines" =>
		array ("US" => true, "UK" =>false, "DE" => true, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Magazines"),
	"Miscellaneous" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Miscellaneous"),
	"Music" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "Music"),
	"MusicalInstruments" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Musical Instruments"),
	"MusicTracks" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => false, "FR" => true,
			"Descr" => "Music Tracks"),
	"OfficeProducts" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Office Products"),
	"OutdoorLiving" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Outdoor Living"),
	"PCHardware" =>
		array ("US" => true, "UK" =>false, "DE" => true, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "PC Hardware"),
	"Photo" =>
		array ("US" => true, "UK" =>false, "DE" => true, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Photo"),
	"Restaurants" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Restaurants"),
	"Software" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "Software"),
	"SoftwareVideoGames" =>
		array ("US" => false, "UK" =>true, "DE" => true, "JP" => false, "CA" => true, "FR" => true,
			"Descr" => "Software/Video Games"),
	"SportingGoods" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "SportingGoods"),
	"Tools" =>
		array ("US" => true, "UK" =>false, "DE" => true, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Tools"),
	"Toys" =>
		array ("US" => true, "UK" =>true, "DE" => false, "JP" => true, "CA" => false, "FR" => false,
			"Descr" => "Toys"),
	"VHS" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "VHS"),
	"Video" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => false,
			"Descr" => "Video"),
	"VideoGames" =>
		array ("US" => true, "UK" =>true, "DE" => true, "JP" => true, "CA" => true, "FR" => true,
			"Descr" => "Video Games"),
	"Wireless" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Wireless"),
	"WirelessAccessories" =>
		array ("US" => true, "UK" =>false, "DE" => false, "JP" => false, "CA" => false, "FR" => false,
			"Descr" => "Wireless Accessories")
	);

print "<form name=\"search\" method=\"get\" action=\"$ThisPage\">\n";
print "<fieldset id=\"search\">\n";
print "<legend>Search Amazon</legend>\n";

// Country pull-down menu
print "<select name=\"c\" id=\"country\">\n";
foreach ($CountryArray as $CountryAbbrev => $CountryAttribs) {
	if ($CountryAbbrev == $Country || $CountryAbbrev == $c) {
		$BaseURL = $CountryAttribs[BaseURL];
		print "<option value=\"$CountryAbbrev\" selected>$CountryAttribs[URL]</option>";
	} else {
		print "<option value=\"$CountryAbbrev\">$CountryAttribs[URL]</option>";
	}
}
print "</select>";

// Search index pull-down menu
print "<select name=\"p\" id=\"searchtype\">\n";
foreach ($SearchIndexArray as $SearchIndex => $SearchIndexAttribs) {
	if ($SearchIndexAttribs[$Country]) {
		if ($SearchIndex == $p) {
			print "<option value=\"$SearchIndex\" selected>$SearchIndexAttribs[Descr]</option>\n";
		} else {
			print "<option value=\"$SearchIndex\">$SearchIndexAttribs[Descr]</option>\n";
		}
	}
}
print "</select>";

$q_decoded = urldecode(str_replace("\'","'",$q));
print "<input type=\"text\" name=\"q\" id=\"query\" value=\"$q_decoded\" />" .
		"<input type=\"submit\" class=\"button\" value=\"Go\" />" .
		"</fieldset></form>";

// Constructs result items into one HTML var
function constructItems($HTML, $ASIN, $URL, $ProductName, $Price, $ImageURLSml, $ImageURLMed, $ImageURLLrg, $p, $q) {
	if ($ProductName != null) {
		$HTML = $HTML.'<div class="item">';
		if ($ImageURLSml != null) {
			$HTML = $HTML."<a href=\"$URL\" title=\"Click here for more information on this product\" " .
					"onclick=\"window.open('$URL');return false;\">" .
					"<img src=\"$ImageURLSml\" alt=\"$ProductName\" /></a>\n";
		}
		$HTML = $HTML."<h4><a href=\"$URL\" title=\"Click here for more information on this product\" " .
				"onclick=\"window.open('$URL');return false;\">$ProductName</a><br />";
		if ($Price != null) {
			$HTML = $HTML."Price: $Price <br />";
		}
		if ($ASIN != null && !is_array($ASIN)) {
			$HTML = $HTML."ASIN: $ASIN";
		}
		$HTML = $HTML."<br /></h4>\n";
		$HTML = $HTML."<form name=\"select\" method=\"post\" action=\"wp-amazon.php\" action=\"$ThisPage\">\n";
		$HTML = $HTML."<input type=\"hidden\" name=\"url\" value=\"$URL\" />\n";
		$HTML = $HTML."<input type=\"hidden\" name=\"prodname\" value=\"$ProductName\" />\n";
		$HTML = $HTML."<input type=\"hidden\" name=\"imgurlsml\" value=\"$ImageURLSml\" />\n";
		$HTML = $HTML."<input type=\"hidden\" name=\"imgurlmed\" value=\"$ImageURLMed\" />\n";
		$HTML = $HTML."<input type=\"hidden\" name=\"imgurllrg\" value=\"$ImageURLLrg\" />\n";
		$HTML = $HTML."<input type=\"hidden\" name=\"p\" value=\"$p\" />\n";
		$HTML = $HTML."<input type=\"hidden\" name=\"q\" value=\"$q\" />\n";
		$HTML = $HTML."<input type=\"submit\" class=\"button\" value=\"Select\" />\n";
		$HTML = $HTML."</form>\n";
		$HTML = $HTML."</div>\n";
	}
	return $HTML;
}

/**** Search Results ****/
if (isset ($p) && isset ($q) && !isset ($_POST['url'])) {

	$q = str_replace("\'","'",$q);
	$Keywords = htmlspecialchars(urlencode($q));
	$URL = $BaseURL."&SubscriptionId=$SubscriptionID"."&AssociateTag=$AssociateTag"."&Operation=ItemSearch"."&SearchIndex=$p"."&ResponseGroup=Medium"."&Keywords=$Keywords";
	$URL .= "&Version=2005-07-27"; // append Amazon ECS version
	$Results = makeXMLTree_wpa($URL);

	if ($debug) {
		print "<pre>";
		print_r($Results);
		print "</pre>";
	}


	$SearchIndices = $Results['ItemSearchResponse']['Items']['SearchResultsMap']['SearchIndex'];
	$Items = $Results['ItemSearchResponse']['Items']['Item'];
	$Count = count($Items);
	$FullTitle = "$q ($Count matches)";

	/* Print result title */
	print "<div id=\"results\">";
	print "<h2>Results for: [$FullTitle]</h2>";

	/* Show result */

	if ($p == 'Blended') {
		$ItemIndex = array ();
		for ($i = 0; $i < count($Items); $i ++) {
			$ItemIndex[$Items[$i]['ASIN'][0]] = $i;
		}

		for ($i = 0; $i < count($SearchIndices); $i ++) {

			$SearchIndex = $SearchIndices[$i];
			$ASINarry = $SearchIndex['ASIN'];
			$HTML = "";

			for ($j = 0; $j < count($ASINarry); $j ++) {
				$ItemNumber = $ItemIndex[$ASINarry[$j]];

				$ASIN = htmlspecialchars($ASINarry[$j]);
				$URL = htmlspecialchars($Items[$ItemNumber]['DetailPageURL']);
				$ProductName = htmlspecialchars($Items[$ItemNumber]['ItemAttributes']['Title']);
				$Price = htmlspecialchars($Items[$ItemNumber]['ItemAttributes']['ListPrice']['FormattedPrice']);
				$ImageURLSml = htmlspecialchars($Items[$ItemNumber]['ImageSets']['ImageSet']['SmallImage']['URL']);
				$ImageURLMed = htmlspecialchars($Items[$ItemNumber]['ImageSets']['ImageSet']['MediumImage']['URL']);
				$ImageURLLrg = htmlspecialchars($Items[$ItemNumber]['ImageSets']['ImageSet']['LargeImage']['URL']);
				$p = htmlspecialchars($p);
				$HTML = constructItems($HTML, $ASIN, $URL, $ProductName, $Price, $ImageURLSml, $ImageURLMed, $ImageURLLrg, $p, $q);
			}
			print "<div class=\"mode\">";
			if ($HTML != null) {
				printf("<h3>%s (%s total results)</h3>\n", htmlspecialchars($SearchIndex['IndexName']), count($ASINarry));
				print $HTML;
			}
			print "</div>\n";
		}

	} else {

		for ($i = 0; $i < count($Items); $i ++) {
			$Item = $Items[$i];
			$ASIN = $Item['ASIN'];
			$URL = htmlspecialchars($Item['DetailPageURL']);
			$ProductName = htmlspecialchars($Item['ItemAttributes']['Title']);
			$Price = htmlspecialchars($Item['OfferSummary']['LowestNewPrice']['FormattedPrice']);
			$ImageURLSml = htmlspecialchars($Item['ImageSets']['ImageSet']['SmallImage']['URL']);
			$ImageURLMed = htmlspecialchars($Item['ImageSets']['ImageSet']['MediumImage']['URL']);
			$ImageURLLrg = htmlspecialchars($Item['ImageSets']['ImageSet']['LargeImage']['URL']);
			$p = htmlspecialchars($p);
			$HTML = constructItems($HTML, $ASIN, $URL, $ProductName, $Price, $ImageURLSml, $ImageURLMed, $ImageURLLrg, $p, $q);
		}
		print $HTML;
	}
}

/**** Item has been selected ****/
$URL = $_POST['url'];
$ProductName = $_POST['prodname'];
if ($areMagicQuotesOn) $ProductName = addslashes($ProductName);
$ProductNameCleaned = stripslashes($_POST['prodname']);
$ImageURLSml = htmlspecialchars($_POST['imgurlsml']);
$ImageURLMed = htmlspecialchars($_POST['imgurlmed']);
$ImageURLLrg = htmlspecialchars($_POST['imgurllrg']);
$p = htmlspecialchars($_POST['p']);
$q = htmlspecialchars(urlencode(str_replace("\'","'",$_POST['q'])));

if (isset ($URL) && isset ($ProductName)) {
	$URL = htmlspecialchars($URL);
	$ProductName = htmlspecialchars($ProductName);
	print "<div id=\"results\">";
	print "<h2><a href=\"$URL\" title=\"Click here for more information on this product\" onclick=\"window.open('$URL');return false;\">$ProductNameCleaned</a></h3>";
	print "<fieldset id=\"options\">";
	print "<legend>How to Include?</legend>\n";
	print "<a href=\"$URL\" title=\"$Click here for more information on this product\" onclick=\"window.open('$URL');return false;\">";
	print "<img src=\"$ImageURLMed\" align=\"left\" /></a>\n";
	print "<label><input type=\"radio\" class=\"radio\" name=\"type\" value=\"link\" onclick=\"generateHTMLCode(this.value, '$ProductName', '$URL', '');\" />Link only</label><br />\n";
	print "<label><input type=\"radio\" class=\"radio\" name=\"type\" value=\"sml\" onclick=\"generateHTMLCode(this.value, '$ProductName', '$URL', '$ImageURLSml');\" />Link with small image</label><br />\n";
	print "<label><input type=\"radio\" class=\"radio\" name=\"type\" value=\"med\" onclick=\"generateHTMLCode(this.value, '$ProductName', '$URL', '$ImageURLMed');\" />Link with medium image</label><br />\n";
	print "<label><input type=\"radio\" class=\"radio\" name=\"type\" value=\"lrg\" onclick=\"generateHTMLCode(this.value, '$ProductName', '$URL', '$ImageURLLrg');\" />Link with large image</label>\n";
	print "</fieldset>\n";
	print "<fieldset id=\"options\">\n";
	print "<legend>HTML Code</legend>\n";
	print "<textarea name=\"htmlcode\" id=\"htmlcode\"></textarea>\n";
	print "</fieldset>\n";
	print "<input type=\"button\" class=\"button\" name=\"addtopost\" value=\"Add to HTML Post\" onclick=\"insertAtCursor(window.opener.document.post.content, document.getElementById('htmlcode').value )\" />\n";
	print "<input type=\"button\" class=\"button\" name=\"close\" value=\"Close Window\" onclick=\"window.close()\" />\n";
	print "&nbsp;<a href=\"$ThisPage?p=$p&amp;q=$q\">Back</a>\n";
	print "</div>\n";
}
?>
	</body>
	</html>
